#version 130
#extension GL_EXT_gpu_shader4 : enable
// Visual sorbetMod01.fsh  by  ap

//https://www.shadertoy.com/view/Xdd3D7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract



float rand(float n)
{
    return fract(sin(n) * 43758.5453123);
}

vec2 rand2(in vec2 p)
{
    return fract(vec2(sin(p.x * 591.32 + p.y * 154.077), cos(p.x * 391.32 + p.y * 49.077)));
}

#define v4White vec4(1.0, 1.0, 1.0, 1.0)
#define v4Black vec4(0.0, 0.0, 0.0, 1.0)
#define v4Grey  vec4(0.5, 0.5, 0.5, 1.0)

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = fragCoord / iResolution.y;

    float freq = 10.0;
    float gap = 1.0/freq;
    float ballrad = 0.3 * gap;
    float jitterrad = 0.2 * gap;

    vec2 param_pos = fract(uv + vec2(iTime / 10.0, 0.0));

    param_pos = uv;

    vec2 closest_center = floor(param_pos * freq + vec2(0.5)) / freq;

    float black_or_white = 0.5 + 0.5 * sin(
        2.0 * 3.14159 * 
        (rand((closest_center.x + 347.0) * (closest_center.y +129.0)) + iTime * 1.0));

    closest_center = closest_center + jitterrad * 1.0 *
        sin((iTime * 0.8 + rand2(closest_center)) * 6.28 +
        sin((iTime * 0.2 + rand2(closest_center.yx)) * 6.28) +
        sin((iTime * 0.5 + rand2(closest_center.xx * 93.0 + 127.0)) * 6.28)
           );

    float dist = length(param_pos - closest_center);  

    float s = (dist * dist) / (ballrad * ballrad);

    fragColor = mix(
        mix(
            mix(v4White, v4Black, 0.0), 
            mix(v4Black, v4White, 0.0), black_or_white), 
        mix(v4White, v4Black, 0.5), 
        smoothstep(ballrad*0.95, ballrad*1.05, dist));
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.